

set.seed(123)
sim.block <- sim(modeL,N.sim)
educ.a.block <- ranef(sim.block)$education[,,1]
agglo.a.block <- ranef(sim.block)$agglo[,,1]
age.a.block <- ranef(sim.block)$age[,,1]
woman.a.block <- ranef(sim.block)$woman[,,1]
beta.a.block <- fixef(sim.block)
ctnr.a.block <- ranef(sim.block)$cantonnr[,,1]
region.a.block <- ranef(sim.block)$region[,,1]


education.pointer <- c(rep(1,32),rep(2,32),rep(3,32),rep(4,32),rep(5,32),rep(6,32))		# for each of the 192 SV it has the right value of "educ"
agglo.pointer <- rep(c(rep(1,8),rep(2,8),rep(3,8),rep(4,8)),6)							# ditto 
age.pointer <- rep(c(1,1,2,2,3,3,4,4),24)												# ditto
woman.pointer <- rep(c(1,2),96)															# ditto
#region.pointer <- c(4,2,6,6,6,6,6,5,6,2,2,3,3,5,5,5,5,5,3,5,7,1,1,2,1,2)


check.vector <- matrix(NA,192,N.sim)

for (j in 1:N.sim){
		for (i in 1:192){
			check.vector[i,j] <- educ.a.block[j,education.pointer[i]] + agglo.a.block[j,agglo.pointer[i]] + age.a.block[j,age.pointer[i]] + woman.a.block[j,woman.pointer[i]]
		}
	}
	
cat("Individual contribution (to the latent variable) calculated.\n")
	
data2 <- read.dta("Context Data.dta")
pred.A.1.latent.cantonal <- matrix(NA, 26, N.sim)
region.pointer <- data2$region

x2.1 <- data2$german
x2.2 <- data2$romancatholic
x2.3 <- data2$gdp_capita
x2.4 <- data2$university
x2.5 <- data2$NR_left_2011
x2.6 <- data2$NR_right_2011




#####
# equivalent to above, I am reading out the right effects for each of the 26 cantons and
# I am adding X*beta' (first term!) 

# specification 1
if(model.spec==1){
		for (j in 1:N.sim){
			for (i in 1:26){
					pred.A.1.latent.cantonal[i,j] <- c(1,x2.1[i])%*%beta.a.block[j,] + ctnr.a.block[j,i] + region.a.block[j,region.pointer[i]]
						}
					}
	}

# specification 2
if(model.spec==2){
		for (j in 1:N.sim){
			for (i in 1:26){
					pred.A.1.latent.cantonal[i,j] <- c(1,x2.2[i])%*%beta.a.block[j,] + ctnr.a.block[j,i] + region.a.block[j,region.pointer[i]]
						}
					}
	}


# specification 4
if(model.spec==4){
		for (j in 1:N.sim){
			for (i in 1:26){
					pred.A.1.latent.cantonal[i,j] <- c(1,x2.4[i])%*%beta.a.block[j,] + ctnr.a.block[j,i] + region.a.block[j,region.pointer[i]]
						}
					}
	}

# specification 5
if(model.spec==5){
		for (j in 1:N.sim){
			for (i in 1:26){
					pred.A.1.latent.cantonal[i,j] <- c(1,x2.5[i])%*%beta.a.block[j,] + ctnr.a.block[j,i] + region.a.block[j,region.pointer[i]]
						}
					}
	}

# specification 64
if(model.spec==64){
		for (j in 1:N.sim){
			for (i in 1:26){
					pred.A.1.latent.cantonal[i,j] <- beta.a.block[j,] + ctnr.a.block[j,i] + region.a.block[j,region.pointer[i]]
						}
					}
	}


cat("Cantonal contribution (to the latent variable) calculated.\n")



latent.synthANDcant <- matrix(NA,26*192,N.sim)

# we need again an object telling us which line belongs to which canton
canton.pointer <- rep(999,26*192)
	for (j in 1:26){
		n1 <- min(which(canton.pointer==999))
		n2 <- n1+191
		#print(n1)
		#print(n2)
		canton.pointer[n1:n2] <- rep(j,192)
	}

# we do the same for the 192 synthetic voters which will appear 26 times
synth.voter.pointer <- rep(c(1:192),26)


# We take the appropriate cantonal prediction and the appropriate synthetic voter prediction and combine it
# again: all done on the latent variable
	for (j in 1:N.sim){	
		for (i in 1:dim(latent.synthANDcant)[1]){
			latent.synthANDcant[i,j] <- pred.A.1.latent.cantonal[canton.pointer[i],j] + check.vector[synth.voter.pointer[i],j]
		}
	}


cat("Cantonal and individual contribution combined - ready for post-stratification step.\n")

# last step; transform latent to predicted probability
pred.prob.synthANDcant <- pnorm(latent.synthANDcant)
pred.vector <- pred.prob.synthANDcant
block <- read.csv("census final BfS 11 2012-- manip v2.0.csv", header = TRUE)
block <- block[,-13]

# Save the first line of each canton
N <- rep(NA,26)
for (i in 1:26){
	n <- 3+i*2411
	N[i] <- n	
}
N <- c(N,65100)
pull.out.BIG <- matrix(NA,192,26)

for (k in 1:26){
	eins <- k
	zwei <- k+1
	#print(k)
	block.use <- as.matrix(block[(N[eins]):(N[zwei]-1),])
	source("pull_out_command_192_1.R")
	pull.out.BIG[,k] <- pull.out
}



cat("Cleaning up .....\n")



pull.out.VECTOR <- rep(NA,dim(pred.vector)[1])

for (j in 0:25){
	eins <- j*192 + 1
	zwei <- (j+1)*192
	drei <- j+1
	pull.out.VECTOR[eins:zwei] <- pull.out.BIG[,drei]
	}

support.matrix <- matrix(NA,length(pull.out.VECTOR),N.sim)

	for (i in 1:N.sim){
		support.matrix[,i] <- pull.out.VECTOR * pred.vector[,i]
	}


cantonal.support <- matrix(NA,26,N.sim)

for (j in 1:N.sim){
	for (k in 0:25){
		eins <- k*192 + 1
		zwei <- (k+1)*192
		drei <- k+1
		#print(eins)
		cantonal.support[drei,j] <- sum(support.matrix[eins:zwei,j])/sum(pull.out.VECTOR[eins:zwei])	
	}
}

cat("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n Preferences have been simulated for this policy!\n")
writeLines(paste("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))
writeLines(paste(" Response Model Specification",model.spec,"is the base.", sep=" "))
writeLines((paste(" The process took:",round(time1[3],1),"seconds.", sep=" ")))
writeLines(paste("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))

